@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route("notify") }}">Envoyer une notification</a>
</li>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="{{ route('sendNotification') }}" method="post" id="createForm" >

                {!! csrf_field() !!}

                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                            <input type="hidden" class="form-control" name="img" id="img" />
                                    <label class="form-col-form-label" for="img_maker">Image de couverture *</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control imgSelector" data-photoMaker="{{ route('PhotoNotify') }}" data-original="" disabled name="img_maker" data-dest="img" id="img_maker" />
                                        <span class="input-group-append">
                                            <button class="btn btn-primary popup_selector" data-inputid="img_maker" type="button">
                                                <i class="fa fa-photo"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-warning popup_selector_colse" data-inputid="img_maker" type="button">
                                                <i class="fa fa-close"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-success popup_selector_visualize" href="" data-inputid="img_maker" type="button" disabled>
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </span>
                                    </div>

                                    <div class="invalid-feedback"></div>
                            </div>
                            
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="text">Text</label>
                                    <textarea class="form-control" id="text" name="text"></textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" id="info" name="info" type="checkbox" value="1">
                                        <label class="form-check-label" for="info">خبر عاجل</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Envoyer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script>
        var elfinderUrl='{{ url("/elfinder/popup") }}/';
        var storagePath='{{ config("paths.STORAGE_PATH") }}';
    </script>
    <link rel="stylesheet" type="text/css" href="{{ asset( 'vendor/colorbox/css/colorbox.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('template/plugins/colorpicker/css/colorpicker.css') }}" >
    <script src="{{ asset('vendor/colorbox/js/jquery.colorbox-min.js') }}"></script>
    <script src="{{ asset('packages/barryvdh/elfinder/js/standalonepopup.js') }}"></script>
    <script src="{{ asset('template/plugins/colorpicker/js/colorpicker.js') }}"></script>
    
    <script src="{{ asset('js/scripts/notify/create.js') }}"></script>
@endsection