@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item active">Newsletter</li>
@endsection()

@section('content')
{!! csrf_field() !!}
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des inscriptions
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Email</td>
                                <td>Adresse Ip</td>
                                <td>Date</td>
                                <td>Annulé</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($subscriptions as $subscription)
                                <tr>
                                    <td>{{ $subscription->id }}</td>
                                    <td>{{ $subscription->email }}</td>
                                    <td>{{ $subscription->created_at->format("d/m/Y") }}</td>
                                    <td>{{ $subscription->ip }}</td>
                                    <td>
                                        @if($subscription->canceled)
                                            Oui
                                        @else
                                            Non
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('deleteNewsletterSubscription',['subscriptionId'=>$subscription->id]) }}" class="btn btn-sm btn-warning deleteSubscription">Supprimer</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>

                    {{ $subscriptions->onEachSide(5)->links() }}
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script src="{{ asset('js/scripts/newsletter/delete.js') }}"></script>
@endsection
