@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item active">
    Migrator
</li>
@endsection

@section("pageTopMenu")
    <a class="btn" href="#" id="lanchMigration">Lancer la migration</a>
    <input type="hidden" id="csrf" value="{{ csrf_token() }}" />
@endsection

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="card">

                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Liste des modules
                    </div>

                    <div class="card-body">
                        <table class="table table-responsive-sm table-striped">
                            <thead>
                                <tr>
                                    <td>Module</td>
                                    <td>Etat</td>
                                    <td>Progression</td>
                                </tr>
                            </thead>
                            <tbody>

                                @for($i=1;$i<=5000;$i++)
                                    <tr>
                                        <td>
                                            Posts part {{$i}}
                                        </td>
                                        <td id="posts{{$i}}ModuleState">
                                            En attente
                                        </td>
                                        <td id="posts{{$i}}ModuleProgress">
                                            0%
                                        </td>
                                    </tr>
                                @endfor
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')

<script>
    var posts=[];
    
    //lanch function
    lanchMigration=function(){
        scriptState=1;
        getPosts(628); //3987, 3850, 3498, 3489, 3225, 2749, 2331, 854
    }


    getPosts=function(i){
        $("#posts"+(628-i)+"ModuleState").html("En cours"); //3987, 3850, 3498, 3489, 3225, 2749, 2331, 854
        $.ajax({
            url:"{{route('migratorPostMigratorImport')}}?part="+i,
            method:"get",
            dataType:"json",
            success:function(data){
                posts=data.posts;
                $("#posts"+(629-i)+"ModuleState").html("Terminé"); //3988, 3851, 3499, 3490, 3226, 2750, 2332, 854
                $("#posts"+(629-i)+"ModuleProgress").html("100%"); //3988, 3851, 3499, 3490, 3226, 2750, 2332, 854
                if(i>1){
                //if(i>4049){
                    i--;
                    getPosts(i);
                }else{
                    console.log("finish");
                }
            }
        });
    }

    //lanch script
    $(document).ready(function(){
        $("#lanchMigration").on("click",function(e){
            e.preventDefault();
            lanchMigration();
        });
    });
</script>
@endsection