@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item active">
    Migrator
</li>
@endsection

@section("pageTopMenu")
    <a class="btn" href="#" id="lanchMigration">Lancer la migration</a>
    <input type="hidden" id="csrf" value="{{ csrf_token() }}" />
@endsection

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="card">

                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Liste des modules
                    </div>

                    <div class="card-body">
                        <table class="table table-responsive-sm table-striped">
                            <thead>
                                <tr>
                                    <td>Module</td>
                                    <td>Etat</td>
                                    <td>Progression</td>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        Users
                                    </td>
                                    <td id="usersModuleState">
                                        En attente
                                    </td>
                                    <td id="usersModuleProgress">
                                        0%
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Categories
                                    </td>
                                    <td id="categoriesModuleState">
                                        En attente
                                    </td>
                                    <td id="categoriesModuleProgress">
                                        0%
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Animators
                                    </td>
                                    <td id="animatorsModuleState">
                                        En attente
                                    </td>
                                    <td id="animatorsModuleProgress">
                                        0%
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Programs
                                    </td>
                                    <td id="programsModuleState">
                                        En attente
                                    </td>
                                    <td id="programsModuleProgress">
                                        0%
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Programs seances
                                    </td>
                                    <td id="programsSeancesModuleState">
                                        En attente
                                    </td>
                                    <td id="programsSeancesModuleProgress">
                                        0%
                                    </td>
                                </tr>
                                @for($i=1;$i<=31;$i++)
                                    <tr>
                                        <td>
                                            Posts part {{$i}}
                                        </td>
                                        <td id="posts{{$i}}ModuleState">
                                            En attente
                                        </td>
                                        <td id="posts{{$i}}ModuleProgress">
                                            0%
                                        </td>
                                    </tr>
                                @endfor
                                <tr>
                                    <td>
                                        Podcasts
                                    </td>
                                    <td id="podcastsModuleState">
                                        En attente
                                    </td>
                                    <td id="podcastsModuleProgress">
                                        0%
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')

<script>
    var users=[];
    var categories=[];
    var animators=[];
    var programs=[];
    var programsSeances=[];
    var podcasts=[];
    var posts=[];
    
    //lanch function
    lanchMigration=function(){
        scriptState=1;
        //getUsers();
        getPrograms();
    }

    //get users function
    getUsers=function(){
        $("#usersModuleState").html("En cours");
        $.ajax({
            url:"{{route('migratorUsers')}}",
            method:"get",
            dataType:"json",
            success:function(data){
                users=data.users;
                $("#usersModuleState").html("Terminé");
                $("#usersModuleProgress").html("100%");
                getCategories();
            }
        });
    }

    //getCategories function
    getCategories=function(){

        $("#categoriesModuleState").html("En cours");
        $.ajax({
            url:"{{route('migratorCategories')}}",
            method:"get",
            dataType:"json",
            success:function(data){
                categories=data.categories;
                $("#categoriesModuleState").html("Términé");
                $("#categoriesModuleProgress").html("100%");
                getAnimators();
                //getPosts(1);
            }
        });
    }

    //get animators
    getAnimators=function(){
        $("#animatorsModuleState").html("En cours");
        $.ajax({
            url:"{{route('migratorAnimators')}}",
            method:"get",
            dataType:"json",
            success:function(data){
                animators=data.animators;
                $("#animatorsModuleState").html("Términé");
                $("#animatorsModuleProgress").html("100%");
                getPrograms();
            }
        });
    }

    //get programs
    getPrograms=function(){
        $("#programsModuleState").html("Récupération des données");
        $.ajax({
            url:"{{route('migratorPrograms')}}",
            method:"get",
            dataType:"json",
            success:function(data){
                programs=data.programs;
                $("#programsModuleState").html("En cours");
                var intRef=setInterval(function(){
                    notreadyfilter=programs.filter(function(oneProgram){
                        return (oneProgram.newID==undefined);
                    });
                    if(notreadyfilter.length==0){
                        clearInterval(intRef);
                        $("#programsModuleProgress").html("100%");
                        $("#programsModuleState").html("Terminé");
                        //continue
                        getSeances();
                        
                    }else{
                        var pourcentage=100-Math.round((100*notreadyfilter.length)/programs.length);
                        $("#programsModuleProgress").html(pourcentage+"%");
                    }
                },1000);
                i=0;
                var saveRef=setInterval(function(){
                    saveProgram(i);
                    i++;
                    if(i==programs.length){
                        clearInterval(saveRef);
                    }
                },300);                
            }
        });
    }

    //save program
    saveProgram=function(index){
        $.ajax({
            url:"{{route('migratorSaveProgram')}}",
            method:"post",
            data:"record="+JSON.stringify(programs[index]),
            dataType:"json",
            success:function(programData){
                programs[index]=programData.program;
            }
        });
    }

    //get seances
    getSeances=function(){
        $("#programsSeancesModuleState").html("Récupération des données");
        $.ajax({
            url:"{{route('migratorProgramsSeances')}}",
            method:"get",
            dataType:"json",
            success:function(data){
                programsSeances=data.programsSeances;
                $("#programsSeancesModuleState").html("En cours");
                var intRef=setInterval(function(){
                    notreadyfilter=programsSeances.filter(function(oneProgramSeance){
                        return (oneProgramSeance.newID==undefined);
                    });
                    if(notreadyfilter.length==0){
                        clearInterval(intRef);
                        $("#programsSeancesModuleProgress").html("100%");
                        $("#programsSeancesModuleState").html("Terminé");
                        //continue
                        getPodcasts();
                        
                    }else{
                        var pourcentage=100-Math.round((100*notreadyfilter.length)/programsSeances.length);
                        $("#programsSeancesModuleProgress").html(pourcentage+"%");
                    }
                },1000);
                i=0;
                var saveRef=setInterval(function(){
                    saveProgramSeance(i);
                    i++;
                    if(i==programsSeances.length){
                        clearInterval(saveRef);
                    }
                },300);                
            }
        });
    }

    //save seances
    saveProgramSeance=function(index){
        thisSeance=programsSeances[index];
        var thisProgram=null;
        for(j=0;j<programs.length;j++){
            if(programs[j].program.program_id==thisSeance.program_id){
                thisProgram=programs[j];
            }
        }
        if(thisProgram!=null){
            $.ajax({
                url:"{{route('migratorSaveProgramSeance')}}",
                method:"post",
                /*headers:{
                    'X-CSRF-TOKEN': $('#csrf').val()
                },*/
                data:"seance="+JSON.stringify(programsSeances[index])+"&program="+JSON.stringify(thisProgram.newID),
                dataType:"json",
                success:function(programData){
                    programsSeances[index]=programData.programSeance;
                }
            });
        }else{
            programsSeances[index].newID=0;
        }
        
    }


    //get podcasts
    getPodcasts=function(){
        $("#podcastsModuleState").html("Récupération des données");
        $.ajax({
            url:"{{route('migratorPodcasts')}}",
            method:"get",
            dataType:"json",
            success:function(data){
                podcasts=data.podcasts;
                $("#podcastsModuleState").html("En cours");
                var intRef=setInterval(function(){
                    notreadyfilter=podcasts.filter(function(onePodcast){
                        return (onePodcast!=null && onePodcast.newID==undefined);
                    });
                    if(notreadyfilter.length==0){
                        clearInterval(intRef);
                        $("#podcastsModuleProgress").html("100%");
                        $("#podcastsModuleState").html("Terminé");
                        //continue
                        
                    }else{
                        var pourcentage=100-Math.round((100*notreadyfilter.length)/podcasts.length);
                        $("#PodcastsModuleProgress").html(pourcentage+"%");
                    }
                },1000);
                i=0;
                var saveRef=setInterval(function(){
                    if(podcasts[i]!=null){
                        savePodcast(i);
                    }
                    console.log(i);
                    i++;
                    if(i==podcasts.length){
                        clearInterval(saveRef);
                    }
                },300);        
            }
        });
    }

    //save seances
    savePodcast=function(index){
        thisPodcast=podcasts[index];

        thisSeance=programsSeances.filter(function(oneSeance){
            return (oneSeance.progcategory_id==podcasts[index].progcategory_id);
        });
        

        /*thisProgram=programs.filter(function(oneProgram){
            return (oneProgram.program.program_id==podcasts[index].program_id);
        });*/
        var thisProgram=null;
        for(j=0;j<programs.length;j++){
            if(programs[j].program.program_id==thisPodcast.program_id){
                thisProgram=programs[j];
            }
        }
        var thisSeance=null;
        for(j=0;j<programsSeances.length;j++){
            if(programsSeances[j].progcategory_id==thisPodcast.progcategory_id){
                thisSeance=programsSeances[j];
            }
        }
        if(thisProgram!=null && thisSeance!=null && thisSeance.newID!=0){
            $.ajax({
                url:"{{route('migratorSavePodcast')}}",
                method:"post",
                /*headers:{
                    'X-CSRF-TOKEN': $('#csrf').val()
                },*/
                data:"podcast="+JSON.stringify(podcasts[index])+"&program="+thisProgram.newID+"&seance="+thisSeance.newID,
                dataType:"json",
                success:function(podcastData){
                    podcasts[index]=podcastData.podcast;
                }
            });
        }else{
            podcasts[index].newID=0;
        }
        
    }

    //lanch script
    $(document).ready(function(){
        $("#lanchMigration").on("click",function(e){
            e.preventDefault();
            lanchMigration();
        });
    });
</script>
@endsection