@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route("menuMobileTags") }}">Menus (tags)</a>
</li>
<li class="breadcrumb-item active">
    Editer menu {{ $menu->title }}
</li>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="{{ route('ajaxUpdateMenuMobileTags',['menuId'=>$menu->id]) }}" method="post" id="editForm" >

                {!! csrf_field() !!}

                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Editer menu
                    </div>

                    <div class="card-body">

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Titre *</label>
                                    <input class="form-control" type="title" value="{{ $menu->title }}" name="title" id="title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="tags">Tags</label>
                                    <select class="form-control" id='tags' name='tags[]'>
                                        @foreach($tags as $tag)
                                            <option value="{{ $tag->id }}" @if($menu->tag_id===$tag->id) selected="selected" @endif>{{ $tag->title }}</option>
                                        @endforeach
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script src="{{ asset('js/scripts/menusMobileTag/edit.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('#tags').select2({
                tags: "true",
                ajax:{
                    url:"{{ route('tagsAjaxList') }}",
                    type:'get',
                    delay: 250,
                    data: function (params) {
                        var query = {
                            term: params.term
                        }
                        return query;
                    },
                    processResults: function (response){
                        return {
                            results:response
                        }
                    }
                },
                minimumInputLength:2
            });
            //$('#tagss').select2();
        });
        CKEDITOR.replace( 'content',CKoptions );
        for (var i in CKEDITOR.instances) {
            CKEDITOR.instances[i].on('change', function() { CKEDITOR.instances[i].updateElement() });
        }
    </script>
@endsection
