@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route("menuMobile") }}">Menus (Application mobile)</a>
</li>
<li class="breadcrumb-item active">
    Editer menu {{ $menu->title }}
</li>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="{{ route('ajaxUpdateMenuMobile',['menuId'=>$menu->id]) }}" method="post" id="editForm" >

                {!! csrf_field() !!}

                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Editer menu
                    </div>

                    <div class="card-body">

                        <div class="row">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Titre *</label>
                                    <input class="form-control" type="title" value="{{ $menu->title }}" name="title" id="title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Visible</label>
                                    <select class="form-control" id='categorie' name='categorie'>
                                        @foreach($categories as $categorie)
                                            <option value="{{ $categorie->id }}" @if($categorie->id==$menu->category_id) selected="selected" @endif}>{{ $categorie->title }}</option>
                                        @endforeach
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Titre *</label>
                                    <input class="form-control" type="color" value="{{ $menu->color }}" name="color" id="color" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('js/scripts/menusMobile/edit.js') }}"></script>
@endsection
