@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item active">
    Menus (tags) 
</li>
@endsection

@section("pageTopMenu")
    <a class="btn" href="{{ route('newMenuMobileTags') }}">+ Ajouter menu</a>
@endsection


@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <form id="menuListForm" action="{{ route('ajxAupdateMenusMobileTags') }}" method="post">
                <input type="hidden" name="list" id="nestable-output" />
                {!! csrf_field() !!}
                <div class="card">

                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Menus (tags)
                    </div>

                    <div class="card-body">
                        <div class="dd" id="nestable">
                            <ol class="dd-list">
                                @foreach($menus as $menu)
                                <li class="dd-item dd3-item" data-id="{{ $menu->id }}">
                                    <div class="dd-handle dd3-handle"></div>
                                    <div class="dd3-content">
                                        {{ $menu->title }}
                                    </div>
                                    <div class="dd-action">
                                        <a href="{{ route('deleteMenuMobileTags',['menuId'=>$menu->id]) }}" class="dd-nodrag mb-3 ml-3 float-right deleteMenu" title="Supprimer">
                                            <i class="icons cui-trash"></i>
                                        </a>
                                        <a href="{{ route('editMenuMobileTags',['menuId'=>$menu->id]) }}" class="dd-nodrag mb-3 float-right" title="Editer">
                                            <i class="fa fa-pencil-square-o"></i>
                                        </a>
                                    </div>
                                    @if(count($menu->childs )>0)
                                        <ol class="dd-list">
                                            @foreach($menu->childs as $child)
                                                <li class="dd-item dd3-item" data-id="{{ $child->id }}">
                                                    <div class="dd-handle dd3-handle"></div>
                                                    <div class="dd3-content">
                                                        {{ $child->title }}
                                                    </div>
                                                    <div class="dd-action">
                                                        <a href="{{ route('deleteMenuMobileTags',['menuId'=>$child->id]) }}" class="dd-nodrag mb-3 ml-3 float-right deleteMenu" title="Supprimer">
                                                            <i class="icons cui-trash"></i>
                                                        </a>
                                                        <a href="{{ route('editMenuMobileTags',['menuId'=>$child->id]) }}" class="dd-nodrag mb-3 float-right" title="Editer">
                                                            <i class="fa fa-pencil-square-o"></i>
                                                        </a>
                                                    </div>
                                                </li>
                                            @endforeach
                                        </ol>
                                    @endif
                                </li>
                                @endforeach
                                
                            </ol>
                        </div>
                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script src="{{ asset('js/scripts/menusMobileTag/list.js') }}"></script>
@endsection
