@extends('dwtemplate.index')

@section("breadcrumb")
    <li class="breadcrumb-item ">
        <a href="{{ route('marchiProductsList') }}">El marchi</a>
    </li>
    <li class="breadcrumb-item active">
        Produits
    </li>
@endsection()

@section("pageTopMenu")
    <a class="btn" href="{{ route('newMarchiProduct') }}">+ Ajouter produit</a>
@endsection

@section('content')
{!! csrf_field() !!}
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des produits
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Titre</td>
                                <td>Catégorie</td>
                                <td>Description</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            @forelse ($products as $product)
                                <tr>
                                    <td>{{ $product->id }}</td>
                                    <td>{{ $product->title }}</td>
                                    <td>{{ $product->marchiCategory->title }}</td>
                                    <td>{{ $product->summary }}</td>
                                    <td>
                                        <a href="{{ route('editMarchiProduct',['marchiProduct'=>$product->id]) }}" class="btn btn-sm btn-primary">Editer</a>
                                        <a href="{{ route('deleteMarchiProduct',['marchiProduct'=>$product->id]) }}" class="btn btn-sm btn-warning deleteProduct">Supprimer</a>
                                    </td>
                                </tr>
                            @empty
                                <tr><td colspan="5">Pas de produit pour le moment</td></tr>
                            @endforelse
                        </tbody>

                    </table>
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('js/scripts/marchi/delete-product.js') }}"></script>
@endsection
