@extends('dwtemplate.index')

@section("breadcrumb")
    <li class="breadcrumb-item ">
        <a href="{{ route('marchiProductsList') }}">El marchi</a>
    </li>
    <li class="breadcrumb-item active">
        Liste des jours
    </li>
@endsection()

@section("pageTopMenu")
    <a class="btn" href="{{ route('newMarchiDay') }}">+ Ajouter un jour</a>
@endsection

@section('content')
{!! csrf_field() !!}
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des jours
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>Date</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($days as $day)
                                <tr>
                                    <td>{{ $day->day_date }}</td>
                                    <td>
                                        <a href="{{ route('editMarchiDay',['day'=>$day->day_date]) }}" class="btn btn-sm btn-primary">Editer</a>
                                        <a href="{{ route('deleteMarchiday',['day'=>$day->day_date]) }}" class="btn btn-sm btn-warning deleteDay">Supprimer</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>

                    {{$days->onEachSide(5)->links()}}
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('js/scripts/marchi/delete-day.js') }}"></script>
@endsection
