@extends('dwtemplate.index')

@section("breadcrumb")
    <li class="breadcrumb-item ">
        <a href="{{ route('marchiProductsList') }}">El marchi</a>
    </li>
    <li class="breadcrumb-item active">
        Catégories
    </li>
@endsection()

@section("pageTopMenu")
    <a class="btn" href="{{ route('newMarchiCategory') }}">+ Ajouter catégorie</a>
@endsection

@section('content')
{!! csrf_field() !!}
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des catégories
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Titre</td>
                                <td>Description</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($categories as $category)
                                <tr>
                                    <td>{{ $category->id }}</td>
                                    <td>{{ $category->title }}</td>
                                    <td>{{ $category->summary }}</td>
                                    <td>
                                        <a href="{{ route('editMarchiCategory',['marchiCategory'=>$category->id]) }}" class="btn btn-sm btn-primary">Editer</a>
                                        <a href="{{ route('deleteMarchiCategory',['marchiCategory'=>$category->id]) }}" class="btn btn-sm btn-warning deleteCategory">Supprimer</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('js/scripts/marchi/delete-category.js') }}"></script>
@endsection
