@extends('dwtemplate.index')

@section("breadcrumb")
    <li class="breadcrumb-item ">
        <a href="{{ route('marchiProductsList') }}">El marchi</a>
    </li>
    <li class="breadcrumb-item ">
        <a href="{{ route('marchiProductsList') }}">Produits</a>
    </li>
    <li class="breadcrumb-item active">
        Editer Produit ({{ $product->title }})
    </li>
@endsection()

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="{{ route('ajxUpdateMarchiProduct',['product'=>$product->id]) }}" method="post" id="editForm" >

                {!! csrf_field() !!}

                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Editer Produit
                    </div>

                    <div class="card-body">

                        <div class="row">

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Titre *</label>
                                    <input class="form-control" type="text" value="{{ $product->title }}" name="title" id="title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_title">Titre SEO *</label>
                                    <input class="form-control" type="text" value="{{ $product->meta_title }}" name="meta_title" id="meta_title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_keywords">Mots Clés *</label>
                                    <input class="form-control" type="text" value="{{ $product->meta_keywords }}" name="meta_keywords" id="meta_keywords" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-col-form-label" for="meta_keywords">Catégorie *</label>
                                        <select name="marchi_category_id" id="marchi_category_id" class="form-control">
                                            @foreach($categories as $category)
                                                <option value="{{ $category->id }}" @if($product->marchiCategory->id==$category->id) selected="selected" @endif>{{ $category->title }}</option>
                                            @endforeach
                                        </select>
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="order">Ordre *</label>
                                    <select class="form-control" name="order" id="order">
                                        @for($i=1;$i<=$cntProd;$i++)
                                            <option value="{{ $i }}" @if($product->order==$i) selected="selected" @endif>{{ $i }}</option>
                                        @endfor
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="summary">Déscription *</label>
                                    <textarea class="form-control" id="summary" name="summary">{{ $product->summary }}</textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_description">Déscription SEO *</label>
                                    <textarea class="form-control" id="meta_description" name="meta_description">{{ $product->meta_description }}</textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                
                                <div class="form-group">
                                    <label class="form-col-form-label" for="img_maker">Image *</label>
                                    
                                    <div class="input-group">
                                        <input type="text" value="{{ $product->img }}" class="form-control imgSelector" data-photoMaker="{{ route('PhotoMarchiProduct') }}" data-original="{{ $product->img }}" disabled name="img_maker" data-dest="img" id="img_maker" />
                                        <span class="input-group-append">
                                            <button class="btn btn-primary popup_selector" data-inputid="img_maker" type="button">
                                                <i class="fa fa-photo"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-warning popup_selector_colse" data-inputid="img_maker" type="button">
                                                <i class="fa fa-close"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-success popup_selector_visualize" href="{{ config("paths.PHOTOS_URL").'marchi/product/'.$product->img }}" data-inputid="img_maker" type="button">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </span>
                                    </div>
                                    <input type="hidden" value="{{ $product->img }}" class="form-control" name="img" id="img" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="img_alt">Alt image*</label>
                                    <input class="form-control" value="{{ $product->img_alt }}" type="text" name="img_alt" id="img_alt" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script>
        var elfinderUrl='{{ url("/elfinder/popup") }}/';
        var storagePath='{{ config("paths.STORAGE_PATH") }}';
        var photosUrl='{{ config("paths.PHOTOS_URL") }}';
    </script>
    <link rel="stylesheet" type="text/css" href="{{ asset( 'vendor/colorbox/css/colorbox.css') }}">
    <script src="{{ asset('vendor/colorbox/js/jquery.colorbox-min.js') }}"></script>
    <script src="{{ asset('packages/barryvdh/elfinder/js/standalonepopup.js') }}"></script>
    
    <script src="{{ asset('js/scripts/marchi/edit-product.js') }}"></script>
@endsection
