@extends('dwtemplate.index')

@section("breadcrumb")
    <li class="breadcrumb-item ">
        <a href="{{ route('marchiProductsList') }}">El marchi</a>
    </li>
    <li class="breadcrumb-item">
        <a href="{{ route('marchiDays') }}">
            Liste des jours
        </a>
    </li>
    <li class="breadcrumb-item active">
        Editer jour ({{ $date->format("d/m/Y") }})
    </li>
@endsection()

@section('content')

<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <form action="{{ route('ajxUpdateMarchiDay',['day'=>$date->format('Y-m-d')]) }}" method="post" id="editForm" >
                {!! csrf_field() !!}
                <div class="card">

                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Editer jour
                    </div>


                    <div class="card-body">

                        @foreach($categories as $category)
                            <h2>{{ $category->title }}</h2>
                            <table class="table table-responsive-sm table-striped">
                                <thead>
                                    <th></th>
                                    <th>Produit</th>
                                    <th>Prix Min</th>
                                    <th>Prix Max</th>
                                </thead>
                                <tbody>
                                    @foreach($category->marchiProducts as $product)
                                        <tr>
                                            <td>
                                                <input type="checkbox" name="product_check_{{ $product->id }}" id="product_check_{{ $product->id }}" class="form-control" @if($product->getDayPrices($date->format("Y-m-d"))) checked @endif />
                                            </td>
                                            <td>
                                                {{ $product->title}}
                                            </td>
                                            <td>
                                                <div clas="form-group">
                                                    <input type="text" name="product_min_price_{{ $product->id }}" value="@if($product->getDayPrices($date->format("Y-m-d"))) {{ $product->getDayPrices($date->format('Y-m-d'))->price_min }} @else 0 @endif" id="product_min_price_{{ $product->id }}" class="form-control" />
                                                    <div class="invalid-feedback"></div>
                                                </div>
                                            </td>
                                            <td>
                                                <div clas="form-group">
                                                    <input type="text" name="product_max_price_{{ $product->id }}" value="@if($product->getDayPrices($date->format("Y-m-d"))) {{ $product->getDayPrices($date->format('Y-m-d'))->price_max }} @else 0 @endif" id="product_max_price_{{ $product->id }}" class="form-control" />
                                                    <div class="invalid-feedback"></div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @endforeach
                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script>
        $(document).ready(function(){
            $("#day_date").datetimepicker({
                format:"D/MM/YYYY"
            });
        });
    </script>
    <script src="{{ asset('js/scripts/marchi/edit-day.js') }}"></script>
@endsection
