@extends('dwtemplate.index')

@section("breadcrumb")
    <li class="breadcrumb-item ">
        <a href="{{ route('marchiProductsList') }}">El marchi</a>
    </li>
    <li class="breadcrumb-item">
        <a href="{{ route('marchiDays') }}">
            Liste des jours
        </a>
    </li>
    <li class="breadcrumb-item active">
        Nouveau jour
    </li>
@endsection()

@section('content')

<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <form action="{{ route('ajxNewMarchiDay') }}" method="post" id="createForm" >
                {!! csrf_field() !!}
                <div class="card">

                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Nouveau jour
                    </div>


                    <div class="card-body">

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="day_date">Date *</label>
                                    <input class="form-control" type="text" name="day_date" id="day_date" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                        </div>

                        @foreach($categories as $category)
                            <h2>{{ $category->title }}</h2>
                            <table class="table table-responsive-sm table-striped">
                                <thead>
                                    <th></th>
                                    <th>Produit</th>
                                    <th>Prix Min</th>
                                    <th>Prix Max</th>
                                </thead>
                                <tbody>
                                    @foreach($category->marchiProducts as $product)
                                        <tr>
                                            <td>
                                                <input type="checkbox" name="product_check_{{ $product->id }}" id="product_check_{{ $product->id }}" class="form-control" checked />
                                            </td>
                                            <td>
                                                {{ $product->title}}
                                            </td>
                                            <td>
                                                <div clas="form-group">
                                                    <input type="text" name="product_min_price_{{ $product->id }}" id="product_min_price_{{ $product->id }}" class="form-control" />
                                                    <div class="invalid-feedback"></div>
                                                </div>
                                            </td>
                                            <td>
                                                <div clas="form-group">
                                                    <input type="text" name="product_max_price_{{ $product->id }}" id="product_max_price_{{ $product->id }}" class="form-control" />
                                                    <div class="invalid-feedback"></div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @endforeach
                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script>
        $(document).ready(function(){
            $("#day_date").datetimepicker({
                format:"DD/MM/YYYY"
            });
        });
    </script>
    <script src="{{ asset('js/scripts/marchi/create-day.js') }}"></script>
@endsection
