@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item active">Kids</li>
@endsection()

@section("pageTopMenu")
    <a class="btn" href="{{ route('newStory') }}">+ Ajouter video</a>
@endsection

@section('content')
{!! csrf_field() !!}
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des videos
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Titre</td>
                                <td>Catégorie</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($stories as $story)
                                <tr>
                                    <td>{{ $story->id }}</td>
                                    <td>{{ $story->title }}</td>
                                    <td>
                                        {{ $story->category->title}}
                                    </td>
                                    <td>
                                        <a href="{{ route('editStory',['storyId'=>$story->id]) }}" class="btn btn-sm btn-primary">Editer</a>
                                        <a href="{{ route('deleteStory',['storyId'=>$story->id]) }}" class="btn btn-sm btn-warning deletePost">Supprimer</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>
                    {{$stories->onEachSide(5)->links()}}
                    
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script src="{{ asset('js/scripts/kids/delete-story.js') }}"></script>
@endsection
