@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route('kidsStoriesList') }}">Liste des videos</a>
</li>
<li class="breadcrumb-item active">
    Editer ({{$story->title}})
</li>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="{{ route('ajxUpdateStory',['storyId'=>$story->id]) }}" method="post" id="editForm" >

                {!! csrf_field() !!}

                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Editer article
                    </div>

                    <div class="card-body">

                        <div class="row">

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Titre *</label>
                                    <input class="form-control" type="title" value="{{ $story->title }}" name="title" id="title" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="category">Catégorie</label>
                                    <select class="form-control" id='category' name='category'>
                                    @foreach($categories as $category)
                                        <option value="{{ $category->id }}" @if($category->id == $story->category->id) selected="selected" @endif >{{ $category->title }}</option>
                                    @endforeach
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="summary">Résumé *</label>
                                    <textarea class="form-control" id="summary" name="summary">{{ $story->summary }}</textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <input type="hidden" name="img" id="img" value="{{ $story->photo }}" />
                                <div class="form-group">
                                    <label class="form-col-form-label" for="img_maker">Image *</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control imgSelector" value="{{ $story->photo }}" data-photoMaker="{{ route('PhotoKids') }}" data-original="{{ $story->photo }}" disabled name="img_maker" data-dest="img" id="img_maker" />
                                        <span class="input-group-append">
                                            <button class="btn btn-primary popup_selector" data-inputid="img_maker" type="button">
                                                <i class="fa fa-photo"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-warning popup_selector_colse" data-inputid="img_maker" type="button">
                                                <i class="fa fa-close"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-success popup_selector_visualize" href="{{ config('paths.PHOTOS_URL').'kids/'.$story->photo }}" data-inputid="img_maker" type="button">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </span>
                                    </div>
                                    
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="youtube_url">Lien Youtube *</label>
                                    <input class="form-control" type="text" value="{{ $story->youtube_url }}" name="youtube_url" id="youtube_url" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script>
        var elfinderUrl='{{ url("/elfinder/popup") }}/';
        var storagePath='{{ config("paths.STORAGE_PATH") }}';
        var photosUrl='{{ config("paths.PHOTOS_URL") }}';
    </script>
    <link rel="stylesheet" type="text/css" href="{{ asset( 'vendor/colorbox/css/colorbox.css') }}">
    <script src="{{ asset('vendor/colorbox/js/jquery.colorbox-min.js') }}"></script>
    <script src="{{ asset('packages/barryvdh/elfinder/js/standalonepopup.js') }}"></script>
    
    <script src="{{ asset('js/scripts/kids/edit-story.js') }}"></script>
@endsection
