@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item active">Contacts</li>
@endsection()

@section('content')
{!! csrf_field() !!}
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des messages
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Nom & Prénom</td>
                                <td>Email</td>
                                <td>Sujet</td>
                                <td>Date</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($contacts as $contact)
                                <tr @if($contact->vue==false) class="font-weight-bold" @endif>
                                    <td>{{ $contact->id }}</td>
                                    <td>{{ $contact->name }}</td>
                                    <td>{{ $contact->email }}</td>
                                    <td>{{ $contact->subject }}</td>
                                    <td>{{ $contact->created_at->format('d/m/Y') }}</td>
                                    <td>
                                        <a href="{{ route('contactShow',['contact'=>$contact->id]) }}" class="btn btn-sm btn-info">Lire</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>
                </div>

            </div>
        </div>
    </div>
</div>
@endsection
