@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route('config') }}">Configuration</a>
</li>

@endsection
@section('content')
{!! csrf_field() !!}
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des paramètres
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Titre</td>
                                <td>Valeur</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($configurations as $config)
                                <tr>
                                    <td>{{ $config->id }}</td>
                                    <td>{{ $config->title }}</td>
                                    <td>{{ $config->value }}</td>
                                    <td>
                                        <a href="{{ route('editConfig',['alias'=>$config->alias]) }}" class="btn btn-sm btn-primary">Editer</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>
                    
                </div>

            </div>
        </div>
    </div>
</div>
@endsection