@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route('config') }}">Configuration</a>
</li>
<li class="breadcrumb-item ">
    <a>{{$config->title}}</a>
</li>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="{{ route('ajxUpdateConfig',['alias'=>$config->alias]) }}" method="post" id="editForm" >

                {!! csrf_field() !!}

                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Editer paramètre
                    </div>

                    <div class="card-body">

                        <div class="row">

                            <div class="col-md-12">
                                <h2>{{$config->title}}</h2>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="content">Valeur</label>
                                    <textarea class="form-control" id="value" name="value"><?php echo $config->value; ?></textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('js')
<script src="{{ asset('js/scripts/configs/update-config.js') }}"></script>
@endsection
