@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route("categoriesList") }}">Categories</a>
</li>
<li class="breadcrumb-item active">
    Editer Catégorie ({{ $category->title }})
</li>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="{{ route('editCategory',['categoryId'=>$category->id]) }}" method="post" id="editForm" >

                {!! csrf_field() !!}

                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Editer catégory
                    </div>

                    <div class="card-body">

                            <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="title">Titre *</label>
                                            <input class="form-control" type="title" name="title" id="title" value="{{ $category->title }}" />
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="meta_title">Titre SEO *</label>
                                            <input class="form-control" type="text" name="meta_title" id="meta_title" value="{{ $category->meta_title }}" />
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="keywords">Mots Clés *</label>
                                            <input class="form-control" type="text" name="keywords" id="keywords" value="{{ $category->keywords }}" />
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="news_keywords">Mots Clés News *</label>
                                            <input class="form-control" type="text" name="news_keywords" id="news_keywords" value="{{ $category->news_keywords }}" />
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="description">Déscription *</label>
                                            <textarea class="form-control" id="description" name="description">{{ $category->description }}</textarea>
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="isActive">Active</label>
                                            <select class="form-control" id='isActive' name='isActive'>
                                                <option value='0'  @if($category->isActive==0) selected='selected' @endif>Inactive</option>
                                                <option value='1'  @if($category->isActive==1) selected='selected' @endif>Active</option>
                                            </select>
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="parent">Parent</label>
                                            <select class="form-control" id='parent' name='parent'>
                                                <option value='0' selected="selected" @if($category->parent_id==0) selected='selected' @endif></option>
                                                @foreach($categories as $line)
                                                    <option value="{{ $line->id }}" @if($category->parent_id==$line->id) selected='selected' @endif>{{ $line->title }}</option>
                                                @endforeach
                                            </select>
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="color">Couleur catégorie *</label>
                                            <input class="form-control color-picker" type="text" value="{{$category->color}}" name="color" id="color" />
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <input type="hidden" name="habillage" id="habillage" value="{{ $category->habillage }}" />
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="habillage_maker">Habillage</label>
                                            <div class="input-group">
                                                <input type="text" class="form-control categoryHabillageSelector" data-photoMaker="{{ route('PhotoCategoryHabillage') }}" value="{{ $category->habillage }}" data-original="{{ $category->habillage }}" data-dest="habillage" disabled name="habillage_maker" id="habillage_maker" />
                                                <span class="input-group-append">
                                                    <button class="btn btn-primary popup_selector" data-inputid="habillage_maker" type="button">
                                                        <i class="fa fa-photo"></i>
                                                    </button>
                                                </span>
                                                <span class="input-group-append">
                                                    <button class="btn btn-warning popup_selector_colse" data-inputid="habillage_maker" type="button">
                                                        <i class="fa fa-close"></i>
                                                    </button>
                                                </span>
                                            </div>

                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-col-form-label" for="habillage_link">Lien Habillage</label>
                                            <input class="form-control" type="text" name="habillage_link" id="habillage_link" value="{{ $category->habillage_link }}" />
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script>
        var elfinderUrl='{{ url("/elfinder/popup") }}/';
        var storagePath='{{ config("paths.STORAGE_PATH") }}';
    </script>
    <link rel="stylesheet" type="text/css" href="{{ asset( 'vendor/colorbox/css/colorbox.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('template/plugins/colorpicker/css/colorpicker.css') }}" >
    <script src="{{ asset('vendor/colorbox/js/jquery.colorbox-min.js') }}"></script>
    <script src="{{ asset('packages/barryvdh/elfinder/js/standalonepopup.js') }}"></script>
    <script src="{{ asset('template/plugins/colorpicker/js/colorpicker.js') }}"></script>

    <script src="{{ asset('js/scripts/categories/edit.js') }}"></script>
@endsection
