@extends('dwtemplate.loginLayout')

@section('content')
<h1>{!! trans('diwan.login') !!}</h1>
<p class="text-muted">{!! trans('diwan.SignInYourAccount') !!}</p>

<form method="POST" action="{{ route('login') }}">

    @csrf

    <div class="input-group mb-3">
        <div class="input-group-prepend">
            <span class="input-group-text">
                <i class="icon-user"></i>
            </span>
        </div>
        <input class="form-control {{ $errors->has('email') ? ' is-invalid' : '' }}" type="email" id="email" name="email" required autofocus value="{{ old('email') }}" placeholder="{!! trans('diwan.Email Adress') !!}">
        @if ($errors->has('email'))
            <span class="invalid-feedback" role="alert">
                <strong>{{ $errors->first('email') }}</strong>
            </span>
        @endif
    </div>

    <div class="input-group mb-3">
        <div class="input-group-prepend">
            <span class="input-group-text">
                <i class="icon-lock"></i>
            </span>
        </div>
        <input class="form-control {{ $errors->has('password') ? ' is-invalid' : '' }}" type="password" id="password" name="password" required autofocus value="{{ old('password') }}" placeholder="{!! trans('diwan.Password') !!}">
        @if ($errors->has('password'))
            <span class="invalid-feedback" role="alert">
                <strong>{{ $errors->first('password') }}</strong>
            </span>
        @endif
    </div>

    <div class="form-check form-check-inline mr-1">
        <input class="form-check-input" id="remember" type="checkbox" name="remember" {{ old('remember') ? 'checked' : '' }}>
        <label class="form-check-label" for="remember">{!! trans('diwan.Remember Me') !!}</label>
    </div>

    <div class="row">
        <div class="col-12">
            <button class="btn btn-primary px-4" type="submit">{!! trans('diwan.login') !!}</button>
        </div>
    </div>

</form>
@endsection
