@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item active">Animateurs</li>
@endsection()

@section('content')
{!! csrf_field() !!}
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des animateurs
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Nom</td>
                                <td>Visible</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($animators as $animator)
                                <tr>
                                    <td>{{ $animator->id }}</td>
                                    <td>{{ $animator->name }}</td>
                                    <td>
                                        @if($animator->public==0)
                                            Non
                                        @else
                                            Oui
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('editAnimator',['animatorId'=>$animator->id]) }}" class="btn btn-sm btn-primary">Editer</a>
                                        <a href="{{ route('deleteAnimator',['animatorId'=>$animator->id]) }}" class="btn btn-sm btn-warning deleteAnimator">Supprimer</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>

                    {{ $animators->onEachSide(5)->links() }}
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script src="{{ asset('js/scripts/animators/delete.js') }}"></script>
@endsection
