@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route('animatorsList') }}">Liste des animateurs</a>
</li>
<li class="breadcrumb-item active">
    Editer animateur ({{ $animator->name }})
</li>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="{{ route('ajxUpdateAnimator',['animatorId'=>$animator->id]) }}" method="post" id="editForm" >

                {!! csrf_field() !!}

                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Editer animateur
                    </div>

                    <div class="card-body">

                        <div class="row">

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Nom *</label>
                                    <input class="form-control" type="text" value="{{ $animator->name }}" name="name" id="name" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="public">Visible</label>
                                    <select class="form-control" id='public' name='public'>
                                        <option value="0"  @if($animator->public==0) selected="selected" @endif>Non</option>
                                        <option value="1"  @if($animator->public==1) selected="selected" @endif>Oui</option>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="role">Role</label>
                                    <select class="form-control" id='role' name='role'>
                                        <option value="منشط" @if($animator->role=='منشط') selected="selected" @endif>منشط</option>
                                        <option value="صحافي" @if($animator->role=='صحافي') selected="selected" @endif>صحافي</option>
                                        <option value="فريق عمل" @if($animator->role=='فريق عمل') selected="selected" @endif>فريق عمل</option>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="description">Déscription *</label>
                                    <textarea class="form-control" id="description" name="description">{{ $animator->description }}</textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_description">Déscription SEO *</label>
                                    <textarea class="form-control" id="meta_description" name="meta_description">{{ $animator->meta_description }}</textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_keywords">Mots Clés *</label>
                                    <input class="form-control" type="text" value="{{ $animator->meta_keywords }}" name="meta_keywords" id="meta_keywords" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="tag">Tag *</label>
                                    <input class="form-control" type="text" value="{{ $animator->tag }}" name="tag" id="tag" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">

                                <div class="form-group">
                                    <label class="form-col-form-label" for="img_maker">Image *</label>

                                    <div class="input-group">
                                        <input type="text" class="form-control imgSelector" value="{{ $animator->img }}" data-photoMaker="{{ route('PhotoAnimator') }}" data-original="{{ $animator->img }}" disabled name="img_maker" data-dest="img" id="img_maker" />
                                        <span class="input-group-append">
                                            <button class="btn btn-primary popup_selector" data-inputid="img_maker" type="button">
                                                <i class="fa fa-photo"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-warning popup_selector_colse" data-inputid="img_maker" type="button">
                                                <i class="fa fa-close"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-success popup_selector_visualize" href="{{config("paths.PHOTOS_URL").'animators/'.$animator->img }}" data-inputid="img_maker" type="button">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </span>
                                    </div>
                                    <input type="hidden" class="form-control" value="{{ $animator->img }}" name="img" id="img" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="img_alt">Alt image*</label>
                                    <input class="form-control" value="{{ $animator->img_alt }}" type="text" name="img_alt" id="img_alt" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script>
        var elfinderUrl='{{ url("/elfinder/popup") }}/';
        var storagePath='{{ config("paths.STORAGE_PATH") }}';
        var photosUrl='{{ config("paths.PHOTOS_URL") }}';
    </script>
    <link rel="stylesheet" type="text/css" href="{{ asset( 'vendor/colorbox/css/colorbox.css') }}">
    <script src="{{ asset('vendor/colorbox/js/jquery.colorbox-min.js') }}"></script>
    <script src="{{ asset('packages/barryvdh/elfinder/js/standalonepopup.js') }}"></script>

    <script src="{{ asset('js/scripts/animators/edit.js') }}"></script>
@endsection
