@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route('animatorsList') }}">Liste des animateurs</a>
</li>
<li class="breadcrumb-item active">
    Nouvel animateur

</li>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form action="{{ route('ajxNewAnimator') }}" method="post" id="createForm" >

                {!! csrf_field() !!}

                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-align-justify"></i>
                        Nouvel animateur
                    </div>

                    <div class="card-body">

                        <div class="row">

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="title">Nom *</label>
                                    <input class="form-control" type="text" name="name" id="name" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="public">Visible</label>
                                    <select class="form-control" id='public' name='public'>
                                        <option value="0" selected="selected">Non</option>
                                        <option value="1" selected="selected">Oui</option>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="role">Role</label>
                                    <select class="form-control" id='role' name='role'>
                                        <option value="منشط" selected="selected">منشط</option>
                                        <option value="صحافي">صحافي</option>
                                        <option value="فريق عمل">فريق عمل</option>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="description">Déscription *</label>
                                    <textarea class="form-control" id="description" name="description"></textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_description">Déscription SEO *</label>
                                    <textarea class="form-control" id="meta_description" name="meta_description"></textarea>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="meta_keywords">Mots Clés *</label>
                                    <input class="form-control" type="text" name="meta_keywords" id="meta_keywords" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="tag">Tag *</label>
                                    <input class="form-control" type="text" name="tag" id="tag" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">

                                <div class="form-group">
                                    <label class="form-col-form-label" for="img_maker">Image *</label>

                                    <div class="input-group">
                                        <input type="text" class="form-control imgSelector" data-photoMaker="{{ route('PhotoAnimator') }}" data-original="" disabled name="img_maker" data-dest="img" id="img_maker" />
                                        <span class="input-group-append">
                                            <button class="btn btn-primary popup_selector" data-inputid="img_maker" type="button">
                                                <i class="fa fa-photo"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-warning popup_selector_colse" data-inputid="img_maker" type="button">
                                                <i class="fa fa-close"></i>
                                            </button>
                                        </span>
                                        <span class="input-group-append">
                                            <button class="btn btn-success popup_selector_visualize" href="" data-inputid="img_maker" type="button" disabled>
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </span>
                                    </div>
                                    <input type="hidden" class="form-control" name="img" id="img" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-col-form-label" for="img_alt">Alt image*</label>
                                    <input class="form-control" type="text" name="img_alt" id="img_alt" />
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>

                        </div>

                    </div>

                    <div class="card-footer">
                        <button class="btn btn-sm btn-success" type="submit">Enregistrer</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('js')
    <script>
        var elfinderUrl='{{ url("/elfinder/popup") }}/';
        var storagePath='{{ config("paths.STORAGE_PATH") }}';
        var photosUrl='{{ config("paths.PHOTOS_URL") }}';
    </script>
    <link rel="stylesheet" type="text/css" href="{{ asset( 'vendor/colorbox/css/colorbox.css') }}">
    <script src="{{ asset('vendor/colorbox/js/jquery.colorbox-min.js') }}"></script>
    <script src="{{ asset('packages/barryvdh/elfinder/js/standalonepopup.js') }}"></script>

    <script src="{{ asset('js/scripts/animators/create.js') }}"></script>
@endsection
