@extends('dwtemplate.index')

@section("breadcrumb")
<li class="breadcrumb-item ">
    <a href="{{ route('AdsList') }}">Liste des pubs</a>
</li>

@endsection
@section('content')
{!! csrf_field() !!}
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">

                <div class="card-header">
                    <i class="fa fa-align-justify"></i>
                    Liste des pubs
                </div>

                <div class="card-body">
                    <table class="table table-responsive-sm table-striped">
                        <thead>
                            <tr>
                                <td>ID</td>
                                <td>Titre</td>
                                <td>Actions</td>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach ($ads as $pub)
                                <tr>
                                    <td>{{ $pub->id }}</td>
                                    <td>{{ $pub->title }}</td>
                                    <td>
                                        @php
                                        $rand=rand();
                                        @endphp
                                        <a href="{{ route('editAds',['adsId'=>$pub->id]) }}?r={{$rand}}" class="btn btn-sm btn-primary">Editer</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>
                    
                </div>

            </div>
        </div>
    </div>
</div>
@endsection