$(document).ready(function(){
    $("#createForm").on("submit",function(e){
        e.preventDefault();
        $(".is-invalid").removeClass("is-invalid");
        $(".invalid-feedback").html("");
        $(':input[type="submit"]').prop('disabled', true);
        $.ajax({
            headers:{'X-CSRF-TOKEN' :$("[name=_token]").val()},
            url: $(this).attr("action"),
            method:"post",
            dataType:"JSON",
            data:$(this).serialize(),
            success:function(data){
                $(':input[type="submit"]').prop('disabled', false);
                window.location.href=data.redirect;
            },
            error:function(errors){
                $(':input[type="submit"]').prop('disabled', false);
                if(errors.status ===422){
                    $.each(errors.responseJSON.errors,function(index,value){
                        $("#"+index).addClass("is-invalid");
                        $("#"+index).parent().find(".invalid-feedback").html(value);
                    });
                }else{
				console.log(errors);
                    alert("Vous n'avez pas le droit d'effectuer cette opération");
                }
            }
        });
    }); 
});
