$(document).ready(function(){
    $("#editForm").on("submit",function(e){
        e.preventDefault();
        $(".is-invalid").removeClass("is-invalid");
        $(".invalid-feedback").html("");
        $(':input[type="submit"]').prop('disabled', true);
        $.ajax({
            headers:{'X-CSRF-TOKEN' :$("[name=_token]").val()},
            url: $(this).attr("action"),
            method:"post",
            dataType:"JSON",
            data:$(this).serialize(),
            success:function(data){
                $(':input[type="submit"]').prop('disabled', false);
                window.location.href=data.redirect;
            },
            error:function(errors){
                $(':input[type="submit"]').prop('disabled', false);
                if(errors.status ===422){
                    $.each(errors.responseJSON.errors,function(index,value){
                        $("#"+index).addClass("is-invalid");
                        $("#"+index).parent().find(".invalid-feedback").html(value);
                        if(index=="mp3_file"){
                            $("#mp3_file_input").addClass("is-invalid");
                            $("#mp3_file").parent().parent().find(".invalid-feedback").html(value);
                        }
                    });
                }else{
                    alert("Vous n'avez pas le droit d'effectuer cette opération");
                }
                
            }
        });
    });

    //image import
    $(".imgSelector").on("change",function(e){

        //prepare image path
        var path=$(this).val().replace("\\",'/').replace("\\",'/');
        $(this).val(path);
        var that=$(this).attr("id");
        $("#"+$(this).attr("data-original")).val(path);

    });

    $(".popup_selector_colse").on("click",function(e){
        e.preventDefault();
        $("#"+$(this).data("inputid")).val("");
        $("#"+$(this).data("inputid")).attr("data-original");
        $("#"+$("#"+$(this).data("inputid")).data("dest")).val("");
        $(".popup_selector_visualize").attr("href","");
        $(".popup_selector_visualize").prop("disabled",true);
    });

    $(".popup_selector_visualize").colorbox();
});