var updateOutput = function(e)
{
    var list   = e.length ? e : $(e.target),
        output = list.data('output');
    if (window.JSON) {
        output.val(window.JSON.stringify(list.nestable('serialize')));
    } else {
        output.val('JSON browser support required for this demo.');
    }
};

// activate Nestable for list 
$('#nestable').nestable({
    group: 1,
    maxDepth:2
})
.on('change', updateOutput);


// output initial serialised data
updateOutput($('#nestable').data('output', $('#nestable-output')));

//form submit
$(document).ready(function(){
    $("#menuListForm").on("submit",function(e){
        e.preventDefault();
        $(".is-invalid").removeClass("is-invalid");
        $(".invalid-feedback").html("");
        $(':input[type="submit"]').prop('disabled', true);
        $.ajax({
            headers:{'X-CSRF-TOKEN' :$("[name=_token]").val()},
            url: $(this).attr("action"),
            method:"post",
            dataType:"JSON",
            data:$(this).serialize(),
            success:function(data){
                $(':input[type="submit"]').prop('disabled', false);
                window.location.href=data.redirect;
            },
            error:function(errors){
                $(':input[type="submit"]').prop('disabled', false);
                if(errors.status ===422){
                    console.log(errors);
                    $.each(errors.responseJSON.errors,function(index,value){
                        $("#"+index).addClass("is-invalid");
                        $("#"+index).parent().find(".invalid-feedback").html(value);
                    });
                }else{
                    alert("Vous n'avez pas le droit d'effectuer cette opération");
                }
            }
        });
    });
});

//delete
$(document).ready(function(){
    $(".deleteMenu").on("click",function(e){
        e.preventDefault();
        if(confirm("vous êtes sûre de vouloir supprimer ce menu?")){
            $('.deleteMenu').prop('disabled', true);
            $.ajax({
                url:$(this).attr("href"),
                method:"delete",
                headers:{'X-CSRF-TOKEN' :$("[name=_token]").val()},
                success:function(data){
                    $('.deleteMenu').prop('disabled', false);
                    window.location.href=data.redirect;
                },
                error:function(errors){
                    $('.deleteMenu').prop('disabled', false);
                    alert("Vous n'avez pas le droit d'effectuer cette opération");
                }
            });
        }
    });
});