<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAnswerssurveyTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('answerssurvey', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name')->default("")->nullable();
            $table->integer('vote')->default(0);
            $table->unsignedBigInteger('surveyId')->nullable()->constrained()->onDelete('set null');
            $table->foreign('surveyId')->references('id')->on('surveys');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('answerssurvey');
    }
}
