<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSitemapLinksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sitemap_links', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('id_index');
            $table->integer('object_type');
            $table->integer('object_id');
            $table->string('url',500);
            $table->float('priority');
            $table->string('changefreq',25);
            $table->date('modified');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sitemap_links');
    }
}
