<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMarchiProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('marchi_products', function (Blueprint $table) {
            $table->increments('id');
            $table->integer("marchi_category_id");
            $table->string("title",500);
            $table->string("img",250);
            $table->string("img_alt",500);
            $table->string("url_rewrite",500);
            $table->text("summary");
            $table->string("meta_title",500);
            $table->text("meta_keywords");
            $table->text("meta_description");
            $table->integer("order");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('marchi_products');
    }
}
