<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePodcast extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('podcasts', function (Blueprint $table) {
            $table->increments('id');
            $table->integer("program_id");
            $table->integer("program_seance_id");
            $table->string("title",1000);
            $table->string("meta_title",1000);
            $table->text("meta_description");
            $table->string("meta_keywords",1000);
            $table->date("live_date");
            $table->integer("duration");
            $table->integer("status"); // 0=>desactivated | 1=>public | 2=>archived
            $table->string("mp3",500);
            $table->string("url_rewrite",1000);
            $table->integer("order");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('podcasts');   
    }
}
