<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePrograms extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('programs', function (Blueprint $table) {
            $table->increments('id');
            $table->string("title",1000);
            $table->string("meta_title",1000);
            $table->text("summary");
            $table->text("content");
            $table->text("meta_description");
            $table->string("meta_keywords",1000);
            $table->string("url_rewrite",1000);
            $table->string("img",255);
            $table->string("img_live",255);
            $table->string("img_alt",1000);
            $table->integer("order");
            $table->integer("status"); //0=>desactivated | 1=>public | 2=> archived
            $table->integer("views")->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('programs');
    }
}
