<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAnimator extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('animators', function (Blueprint $table) {
            $table->increments('id');
            $table->string("name",1000);
            $table->text("description");
            $table->text("meta_description");
            $table->string("meta_keywords",1000);
            $table->string("url_rewrite",1000);
            $table->string("img",255);
            $table->string("img_alt",1000);
            $table->integer("public"); //0=>no | 1=>yes
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('animators');
    }
}
