<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePostsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('posts', function (Blueprint $table) {
            $table->increments('id');
            $table->integer("user_id");
            $table->string("title",1000);
            $table->text("summary");
            $table->text("content");
            $table->string("meta_title",1000);
            $table->text("meta_description");
            $table->string("meta_keywords",1000);
            $table->string("meta_news_keywords",1000);
            $table->string("url_rewrite",1000);
            $table->string("img",255);
            $table->string("img_alt",255);
            $table->integer("type"); //0=>article | 1=>video | 2=>image library
            $table->integer("status"); //  0=>brouillons | 1=>En attente de publication | 2=>publié
            $table->integer("flash_news")->defaul(0); //  0=>no | 1=>yes
            $table->integer("facebook_instant_article")->defaul(0); //  0=>no | 1=>yes
            $table->integer("google_amp")->defaul(0); //  0=>no | 1=>yes
            $table->text("video_url");
            $table->integer("video_source"); // 0=>youtube | 1=>facebook
            $table->integer("views");
            $table->integer("last_news")->defaul(0); // 0=>no | 1=>yes
            $table->timestamp("last_news_date");
            $table->timestamp("published");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('posts');
    }
}
