<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use App\Notifications\ResetPasswordNotification;
use NotificationChannels\WebPush\HasPushSubscriptions;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Utilisateur extends Authenticatable implements MustVerifyEmail
{
    // use HasPushSubscriptions;
    use Notifiable;


    protected $table = 'utilisateurs';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token','uuid4'
    ];

    public function __construct()
    {

    }


    public function getName(): ?string
    {
        return $this->name;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): self
    {
        $this->email = $email;
        return $this;
    }

    public function getEmailVerifiedAt(): ?string
    {
        return $this->emailVerifiedAat;
    }


    /**
     * Send the password reset notification.
     * @note: This override Authenticatable methodology
     *
     * @param  string  $token
     * @return void
     */
    public function sendPasswordResetNotification($token)
    {
        $this->notify(new ResetPasswordNotification($token));
    }


    public function categories()
    {
        return $this->belongsToMany('App\Category', 'category_utilisateur', 'utilisateur_id', 'category_id');
    }


    /**
     * check multiple categorys
     * @param $categories
     * @return bool
     */
    public function hasAnyCategory($categories){
        return null !== $this->categories()->whereIn('id',$categories)->first();
    }

    /**
     * check one category
     * @param $categorie
     * @return bool
     */
    public function hasCategory($categorie){
        return null!==$this->categories()->where('id',$categorie)->first();
    }





}

