<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Carbon;

class SitemapLink extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'id_index',
        'object_type',
        'object_id',
        'url',
        'priority',
        'changefreq',
        'modified',
    ];

    /**
     * The attributes that are mass assignable.
     *
     * @var string
     */
    protected $routeLink;
    protected $linkPrefixes;
    protected $priorities;
    protected $changefreqs;
    /**
     * construct function
     */
    public function __construct(){
        parent::__construct();
        $this->linkPrefixes=config('dwsitemap.linkPrefixes');
        $this->routeLink = config('dwsitemap.routeLink');
        $this->priorities = config('dwsitemap.priority');
        $this->changefreqs = config('dwsitemap.changefreq');
    }
    /**
     * link prefix by type
     * @var array
     */

    public static function GetSitemapLinks($indexId){
        $sitemapLinks = SitemapLink::whereIdIndex($indexId)->get();
        return $sitemapLinks;
    }

    public function getRoutLink($type){
        return $this->routeLink.$this->linkPrefixes[$type];
    }
    /**
     * Insert Sitemap Link
     * @param int
     * @param int
     * @param string
     * @return void
     */
    public function InsertSitemapLink($objectType,$objectId,$objectUrl){
        $sitemapIndex = SitemapIndex::GetSitemapIndex();
        $sitemapLink = new SitemapLink();
        //Data to save
        $sitemapLink->id_index = $sitemapIndex->id;
        $sitemapLink->object_type = $objectType;
        $sitemapLink->object_id = $objectId;
        $sitemapLink->url = $objectUrl;
        $sitemapLink->modified = Carbon::now();
        //priority & changefreq
        $sitemapLink->priority = $this->priorities[$objectType];
        $sitemapLink->changefreq = $this->changefreqs[$objectType];
        $sitemapLink->save();
        SitemapIndex::InsertSitemapIndex();
    }
    /**
     * Edit Sitemap Link
     * @param int
     * @param int
     * @return void
     */
    public static function UpdateSitemapLink($objectType,$objectId){
        $sitemapLink = SitemapLink::whereObjectId($objectId)->whereObjectType($objectType)->first();
        if($sitemapLink){
            $sitemapLink->modified = Carbon::now();
            $sitemapLink->save();
        }
        
    }

    /**
     * Delete Sitemap Link
     * @param int
     * @param int
     * @return void
     */
    public static function DeleteSitemapLink($objectType,$objectId){
        $sitemapLink = SitemapLink::whereObjectId($objectId)->whereObjectType($objectType)->first();
        if($sitemapLink){
            SitemapIndex::DeleteSitemapIndex($sitemapLink->id_index);
            $sitemapLink->delete();
        }
        
    }
}
