<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SitemapIndex extends Model
{

    protected $table="sitemap_indexes";


    public static function GetSitemapIndex(){
        $sitemapIndex = SitemapIndex::where('number', '<', 50000)->first();
        if(!$sitemapIndex){
            $sitemapIndex=new SitemapIndex();
            $sitemapIndex->number=0;
            $sitemapIndex->save();
        }
        return $sitemapIndex;
    }

    public static function InsertSitemapIndex(){
        $sitemapIndex = SitemapIndex::GetSitemapIndex();
        $sitemapIndex->number++;
        $sitemapIndex->save();
    }

    public static function DeleteSitemapIndex($id){
        $sitemapIndex = SitemapIndex::whereId($id)->first();
        $sitemapIndex->number--;
        $sitemapIndex->save();        
    }
}
