<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ProgramSeance extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'program_id',
        'title',
        'meta_title',
        'meta_description',
        'meta_keywords',
        'url_rewrite',
        'order',
    ];

    public function program(){
        return $this->belongsTo(Program::class,'program_id');
    }

    public function podcasts(){
        return $this->hasMany(Podcast::class);
    }
}
