<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Program extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'animator_id',
        'title',
        'meta_title',
        'summary',
        'content',
        'meta_description',
        'meta_keywords',
        'url_rewrite',
        'img',
        'img_live',
        'img_alt',
        'order',
        'status',
        'views',
        'hashtag'
    ];

    public function animators(){
        return $this->belongsToMany(Animator::class);
    }

    public function podcasts(){
        return $this->hasMany(Podcast::class);
    }

    public function programSeances(){
        return $this->hasMany(ProgramSeance::class);
    }

    public function programmings(){
        return $this->hasMany(Programming::class);
    }
}
