<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Post extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'title',
        'summary',
        'content',
        'meta_title',
        'meta_description',
        'meta_keywords',
        'meta_news_keywords',
        'url_rewrite',
        'img',
        'img_alt',
        'type',
        'status',
        'flash_news',
        'facebook_instant_article',
        'google_amp',
        'video_url',
        'video_source',
        'views',
        'published',
        'last_news',
        'last_news_date',
        'title',
        'display_user_id',
        'lang',
        'private_post',
        'rss_title'
    ];

    public function user(){
        return $this->belongsTo(User::class);
    }

    public function displayUser(){
        return $this->belongsTo(User::class,"display_user_id");
    }

    public function categories(){
        return $this->belongsToMany(Category::class);
    }

    public function tags(){
        return $this->belongsToMany(Tag::class,"tag_post");
    }

    public function photos(){
        return $this->hasMany(PostPhoto::class);
    }

}
