<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Podcast extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'program_id',
        'program_seance_id',
        'meta_title',
        'meta_description',
        'meta_keywords',
        'live_date',
        'duration',
        'status',
        'mp3',
        'url_rewrite',
        'order',
    ];

    public function program(){
        return $this->belongsTo(Program::class);
    }

    public function programSeance(){
        return $this->belongsTo(ProgramSeance::class);
    }

    public function animators(){
        return $this->belongsToMany(Animator::class);
    }
}
