<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class MarchiProduct extends Model
{
    public function marchiCategory(){
        return $this->belongsTo(MarchiCategory::class,'marchi_category_id');
    }

    public function marchiPrices(){
        return $this->hasMany(MarchiPrice::class);
    }

    public function getDayPrices($date){
        return MarchiPrice::whereDayDate($date)->whereMarchiProductId($this->id)->first();
    }
}
