<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateProgrammingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $conditions=[
            'start_time' => "bail|required|date_format:H:i:s",
            'end_time' => "bail|required|date_format:H:i:s|after:start_time"
        ];
        return $conditions;
    }

    public function attributes(){
        return [
            "start_time"=>"Heure Début",
            "end_time"=>"Heure Fin",
        ];
    }
}
