<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateProgramSeanceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $conditions=[
            'title' => "bail|required|max:1000",
            'meta_title' => "bail|required|max:1000",
            'meta_description' => "bail|required",
            'meta_keywords' => "bail|required|max:1000",
        ];
        return $conditions;
    }

    public function attributes(){
        return [
            "title"=>"Titre",
            "meta_title"=>"Titre SEO",
            "meta_description"=>"Déscription SEO",
            "meta_keywords"=>"Mots clès"
        ];
    }
}
