<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateMarchiDayRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $conditions=[];
        foreach($this->input() as $key=>$value){
            if(substr($key,0,18)=="product_min_price_"){
                if($this->input("product_check_".substr($key,18,(strlen($key)-18)))){
                    $conditions[$key]="bail|required|integer";
                }
            }
            if(substr($key,0,18)=="product_max_price_"){
                if($this->input("product_check_".substr($key,18,(strlen($key)-18)))){
                    $conditions[$key]="bail|required|integer|gte:product_min_price_".substr($key,18,(strlen($key)-18));
                }
            }
        }

        return $conditions;
    }

    public function attributes(){

        $attrs=[];
        foreach($this->input() as $key=>$value){
            if(substr($key,0,18)=="product_min_price_"){
                $attrs[$key]="Prix Min";
            }
            if(substr($key,0,18)=="product_max_price_"){
                $attrs[$key]="Prix Max";
            }
        }
        return $attrs;
    }
}
