<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateGalleryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $conditions=[
            'title' => "bail|required|max:1000",
            'meta_title' => "bail|required|max:1000",
            'category' => "bail|required",
            'summary' => "bail|required",
            'meta_description' => "bail|required",
            'meta_keywords' => "bail|required|max:1000",
            'meta_news_keywords' => "bail|required|max:1000",
            'img' => "bail|required",
            'img_alt' => "bail|required|max:1000",
            'content' => "bail|required",
        ];
        return $conditions;
    }
}
