<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateAnimatorRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $conditions=[
            'name' => "bail|required|max:1000",
            'description' => "bail|required",
            'meta_description' => "bail|required",
            'meta_keywords' => "bail|required|max:1000",
            'img' => "bail|required",
            'img_alt' => "bail|required|max:1000",
            'tag' => "bail|required|max:500",
        ];
        return $conditions;
    }

    public function attributes(){
        return [
            "name"=>"Nom",
            "description"=>"Déscription",
            "meta_description"=>"Déscription SEO",
            "meta_keywords"=>"Mots Clés",
            "img"=>"Image",
            "img_alt"=>"Alt image",
            'tag' => "Tag",
        ];
    }
}
