<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'email' => "bail|required|email|unique:users,email|max:250",
            'name' => "bail|required|max:250",
            'password' => "bail|required|max:250",
            'conf_password' => "bail|required|same:password",
        ];
    }
}
