<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateProgramRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $conditions=[
            //'animators' => "bail|required",
            'title' => "bail|required|max:1000",
            'meta_title' => "bail|required|max:1000",
            'summary' => "bail|required",
            'content' => "bail|required",
            'meta_description' => "bail|required",
            'meta_keywords' => "bail|required|max:1000",
            'img' => "bail|required",
            'img_alt' => "bail|required|max:1000",
        ];
        return $conditions;
    }

    public function attributes(){
        return [
            "animators"=>"Animateurs",
            "title"=>"Titre",
            "meta_title"=>"Titre SEO",
            "summary"=>"Déscription",
            "meta_description"=>"Déscription SEO",
            "meta_keywords"=>"Mots clès",
            "img"=>"Image",
            "img_live"=>"Image Live",
            "img_alt"=>"Alt image"
        ];
    }
}
