<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreatePodcastRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => "bail|required|max:500",
            'live_date'=>"bail|required|date_format:d/m/Y H:i:s",
            'animator'=>"bail|required",
            'mp3_file'=>"bail|required",
            'seance'=>"bail|required",
            'meta_description'=>"bail|required",
            'meta_title'=>"bail|required|max:500",
            'meta_keywords'=>"bail|required",
        ];
    }

    public function attributes(){
        return [
            "title"=>"Titre",
            "meta_title"=>"Titre Seo",
            "meta_keywords"=>"Mots Clés",
            "live_date"=>"Date live",
            "animator"=>"Animateurs",
            "mp3_file"=>"Fichier MP3",
            "seance"=>"Emission",
            "meta_description"=>"Déscription SEO",
        ];
    }
}
